c**********************************************************************************
c     FORTRAN code
c     File: PDF.FOR
c     WRITTEN BY: Yuzhi CAI and adjusted by JDG
C
c     Program to find conditional pdf, cdf of SETAR model with given parameters
c     at a given forecast origin. Also finds median forecast and prediction
c     interval  from cdf and the mean, variance, and mean
c     absolute deviation from median.
c
c     If data have been transformed, either by log or Box-Cox square root, then
c     the pdf for the raw data is computed.
c
c     Throughout, a Gaussian noise distribution is assumed regionally.
c     References:
c     Cai, Y. (2003). 
c       Convergence theory of a numerical method for solving the Chapman-Kolmogorov 
c       equation. SIAM Journal on Numerical Analysis, 40(6), 2337-2351.
c       DOI: 10.1137/s0036142901390366.
c     Cai, Y. (2005). 
c       A forecasting procedure for nonlinear autoregressive time series models.
c       Journal of Forecasting, 24(5), 335-351.
c       DOI: 10.1002/for.959.
C***********************************************************************************
c     .. parameters ..
      integer         nin, nout
      parameter       (nin=4,nout=8)
      dimension pdf(1000),xax(1000)
c     character*80tx,ty,tg
c	external xxxxxx,j06vaf,j06waf,j06wdf,j06wzf
c

      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V
c
      r2pi=sqrt(8.0*atan(1.0))
      eps=1e-4
      open(5,file='newprog.2res')
c     ymi=0
c	umi=0
c	uma=1
c	vmi=0.1
c	vma=0.9
c     tx='x(t)'
c     ty='conditional pdf'
      call coeffs
c     print*,' input 0 if model fitted to raw data, 1 o.w.'
c     read*,itrans
      itrans=0
      if(itrans.eq.1) then
	 print*,' input 1 for log, 2 for sqrt:'
	 read*, itrans
      endif
      if(itrans.eq.1)then
	print*, 'base of logs?'
	read*,alpha
	beta=log(alpha)
      endif
c     print*,'input xmin,xmax for transformed data:'
c     read*,xmi,xma
      xmi=0
      xma=100
c
c     print*,'input required % level for prediction limits:'
c     read*,cl
      cl=5
c
      blev=(1.0-cl/100.0)/2.0
      ulev=1.0-blev
c     print*,'left and right tail areas to be left off all pdf plots:'
c     read*,perl,perr
      perr=0
      perl=0
c
      perr=1-perr
      pr100=100*perr
      pl100=100*perl
c
c     open non graphical output file
c
      open (nout,file='j06bafex.err')
c
c     select output channel for error messages
c
c     call j06vaf(1,nout)
c
c     initialise plotting device
c
c     call xxxxxx
c     call j06waf
c	isup=0
c	itype=0
c	ksym=2
c     call dclock@(start)
      call mandv(id,1,0)
c     call dclock@(finish)
c     write(5,*)' mean      variance'
c     print*,' mean      variance'
c     print*,'time for means/vars up to ',id,' = ',finish-start
c     write(5,*)'time for means/vars up to ',id,' = ',finish-start
      do 10 mfinal=1,11
      last=0
      v=0
      xinit=(xmi+xma)/2
      xinc=.1*(xma-xmi)
      xxx=xinit
      if(mfinal.gt.id)then
c       call dclock@(start)
        write(*,*) ' voor rabwg in main'
        call rabwg
        write(*,*) ' na rabwg'
c
c       call dclock@(finish)
c       write(5,*)'time to get qr = ',finish-start
	xxx=xinit
c       call dclock@(start)
	call root(0.5,aa)
c       call dclock@(finish)
c       write(5,*)'time to get median = ',finish-start
      else
	lastl=x(mfinal+k)
	lastv=mse(mfinal)
	aa=lastl
	last=1
      endif
c     call dclock@(start)
      xxx=aa
      write(*,*) 'before first root in main '
      call root(ulev,chih)
      xxx=aa
      write(*,*) 'before 2nd root in main '
      call root(blev,clow)
      xxx=chih
      write(*,*) 'before 3rd root in main '
      call root(perr,xma)
      xxx=clow
      call root(perl,xmi)
c     call dclock@(finish)
c     write(5,*)'time to get prediction limits = ',finish-start
      xax(1)=xmi
      ix=0
      yma=0
      h=(xma-xmi)/50.0
c     call dclock@(start)
      do 20 xx=xmi,xma,h
         ix=ix+1
         if(ix.gt.1000)write(5,*)'too many pdf values for plotting'
           xax(ix)=xx
           xxx=xx
           write(*,*) ' just for eval1'
c
           call eval1(1,fx,fcumx)
           pdf(ix)=fx
           yma=max(yma,fx)
20    continue
c     call dclock@(finish)
c     write(5,*)'time to evaluate pdf = ',finish-start
      write(5,*)
      write(5,*)'# steps = ',mfinal
      write(5,*)
      write(5,*)'median by newton-raphson method is ',aa
      write(5,*)
      write(5,*)cl,' % pred limits are ( ',clow,' , ',chih,' )'
      write(5,*)'lower ',pl100,' % point is ',xmi
      write(5,*)'upper ',pr100,' % point is ',xma
      write(5,*)'varr(',mfinal,')=',sqrt(varr(mfinal))
      write(5,*)'meann(',mfinal,')=',meann(mfinal)
c     write(5,21)
c     write(tg,11)'conditional pdf at ',mfinal,' steps'
c	call ptplot(xax,pdf,umi,uma,vmi,vma,xmi,xma,ymi,yma,
c    *itype,ksym,ix,tx,ty,tg,isup)
c	call j06wdf
      if(itrans.eq.1)then
	 write(5,*)
	 write(5,*)'backtransforming from logs to base ',alpha
	 write(5,*)'**************************************************'
	 write(5,*)
	 xtmin=exp(beta*xmi)
	 xtmax=exp(beta*xma)
	 aa=exp(beta*aa)
	 clow=exp(beta*clow)
	 chih=exp(beta*chih)
	 write(5,*)
	 write(5,*)'backtransformed median is ',aa
	 write(5,*)'backtransformed prediction limits are ( ',clow,' ,
     1 ',chih,' )'
	 write(5,*)'lower ',pl100,' % point is ',xtmin
	 write(5,*)'upper ',pr100,' % point is ',xtmax
	 write(5,*)
c        write(5,21)
c	 write(tg,41)'raw data conditional pdf at ',mfinal,' steps'
	 ht=(xtmax-xtmin)/50.0
	 ix=0
	 yma=0
	 do 40 xt=xtmin,xtmax,ht
	 ix=ix+1
	 xax(ix)=xt
	 xxx=log(xax(ix))/beta
	 call eval1(0,fx,fcumx)
	 pdf(ix)=fx/beta/xax(ix)
	 yma=max(yma,pdf(ix))
 40       continue
c	call ptplot(xax,pdf,umi,uma,vmi,vma,xtmin,xtmax,ymi,yma,
c    *itype,ksym,ix,tx,ty,tg,isup)
c	call j06wdf
      elseif(itrans.eq.2)then
	 write(5,*)
	 write(5,*)'backtransforming from box-cox square root'
	 write(5,*)'**************************************************'
	 write(5,*)
	 xtmin=(xmi/2.0+1.0)**2-1.0
	 xtmax=(xma/2.0+1.0)**2-1.0
	 aa=(aa/2.0+1.0)**2-1.0
	 clow=(clow/2.0+1.0)**2-1.0
	 chih=(chih/2.0+1.0)**2-1.0
	 ht=(xtmax-xtmin)/50.0
	 ix=0
	 yma=0
	 do 30 xt=xtmin,xtmax,ht
	 ix=ix+1
	 xax(ix)=xt
	 xxx=2*(sqrt(xt+1)-1)
	 call eval1(0,fx,fcumx)
	 pdf(ix)=fx/(xxx/2+1)
	 yma=max(yma,pdf(ix))
30       continue
	 write(5,*)
	 write(5,*)'backtransformed median is ',aa
	 write(5,*)
	 write(5,*)'backtransformed prediction limits are ( ',clow,' ,
     1 ',chih,' )'
	 write(5,*)'lower ',pl100,' % point is ',xtmin
	 write(5,*)'upper ',pr100,' % point is ',xtmax
	 write(5,*)
c         write(5,21)
c	 write(tg,41)'raw data conditional pdf at ',mfinal,' steps'
c	call ptplot(xax,pdf,vmi,vma,vmi,vma,xtmin,xtmax,ymi,yma,
c    *itype,ksym,ix,tx,ty,tg,isup)
c	call j06wdf
      endif
10    continue
c     call devfin
c
c     terminate plotting
c
c     call j06wzf
c
      close(5)
11    format(a19,i2,a6)
21    format(4x,'simpson results:-',//,10x,'integral',10x,'mean',10x,
     1'mean square',10x,'st dev',10x,'mad')
31    format(8x,5(e14.6,3x))
41    format(a28,i2,a6)
      end
c
c
C     Start of SUBROUTINE WWXX
C
      SUBROUTINE WWXX(A,B,LAM,S,NPTS,WW,XX,EE,NSIZE,NOUT)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        LOGICAL BOOL
C***********************************************************************
C     Calculates the weights(WW) and the abscissae(XX) for the
C     NPTS-quadrature rule for the integral of
C              exp(-(t-lam)**2*s*s/2)*f(t)
C     with respect to t from a to b.The abscissae are stored in
C     XX(I,J),I=1,NPTS,J=1,I and the corresponding weights in
C     WW(I,J),I=1,NPTS,J=1,I.If for any reason the NPTS-rule cannot
C     be calculated the order of the highest rule which can be
C     found is stored in NOUT
C     All the calculations are done double length.
C     The vector E contains the error constant.
C**********************************************************************
CV      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NSIZE,NOUT
      DIMENSION WW(0:NSIZE,0:NSIZE),XX(0:NSIZE,0:NSIZE),EE(0:NSIZE)
      REAL*8 A,B,LAM,S,WW,XX,EE
C
C     Local variables
C
      DIMENSION II(0:20),V(0:20),AA(-1:20),BB(0:20),CC(0:20),
     *   ALPHA(0:20),BETA(0:20),GAMMA(0:20),
     *   WWW(0:20,0:20),XXX(0:20,0:20)
      DOUBLE PRECISION  II,V,AA,BB,CC,ALPHA,BETA,GAMMA,C,D,
     *   SUM,FACT,T1,T2,W,X,E,MAX,WWW,XXX
      INTEGER NMTS,I,J,K
C
C     Initialise variables
C
      C=DBLE((A-LAM)/S)
      D=DBLE((B-LAM)/S)
      NMTS=2*NPTS
C
C     Calculate the moments (II) and the generalised moments (V)
C
      CALL MOMENT(C,D,II,V,20,NMTS)
C
C     Check if the moments are small
C
      MAX=ABS(V(0))
      DO 10 I=1,NMTS
       IF(ABS(V(I)).GT.MAX) MAX=ABS(V(I))
   10 CONTINUE
      IF((MAX.LT.1D-6).OR.(ABS(V(0)).LT.1D-6)) THEN
        NOUT=0
        GOTO 51
      ENDIF
C     PRINT*
C      PRINT*,'MOMENTS'
C      DO 20 I=0,NMTS
C       PRINT*,II(I),V(I)
C   20 CONTINUE
C
C     Set up the fundamental matrix
C
      CALL FUNMAT(C,D,NMTS,AA,BB,CC,20)
C      PRINT*,'FUNDAMENTAL MATRIX'
C      DO 30 I=0,NMTS
C      PRINT*,AA(I),BB(I),CC(I)
C  30  CONTINUE
C
C     Set up the terminal matrix
C
      NOUT=NPTS
      CALL TERMAT(AA,BB,CC,II,V,NPTS,ALPHA,BETA,GAMMA,20,20,NOUT)
C     PRINT*
C      PRINT*,'TERMINAL MATRIX'
C      DO 40 I=0,NPTS
C       PRINT*,ALPHA(I),BETA(I),GAMMA(I)
C   40 CONTINUE
C
C     Now calculate the weights and abscissae for the n point rule
C
      XXX(1,0)=C
      XXX(1,1)=BETA(0)
      XXX(1,2)=D
      WWW(1,1)=V(0)
      DO 50 I=2,NOUT
      DO 60 J=1,I
      T1=XXX(I-1,J-1)
      T2=XXX(I-1,J)
      CALL NEWTON(T1,T2,ALPHA,BETA,GAMMA,I,20,W,X,BOOL)
      IF(.NOT.BOOL) THEN
       NOUT=I-1
       GOTO 51
      ENDIF
      WWW(I,J)=-W*V(0)
      XXX(I,J)=X
   60 CONTINUE
      XXX(I,0)=C
      XXX(I,I+1)=D
   50 CONTINUE
   51 CONTINUE
C     PRINT*
C      PRINT*,'  Weights and abscissae are as follows '
C      PRINT*
C      DO 80 I=1,NOUT
C         PRINT*,(WWW(I,J),XXX(I,J),J=1,I)
C   80 CONTINUE
C
C     Check the results
C
      FACT=1.0
      DO 90 I=1,NOUT
      FACT=2*I*(2*I-1)*FACT
      DO 100 J=0,2*I
       SUM=0.0
       DO 120 K=1,I
        IF(J.EQ.0) THEN
         SUM=SUM+WWW(I,K)
        ELSE
         SUM=SUM+WWW(I,K)*XXX(I,K)**J
        ENDIF
  120  CONTINUE
       E=II(J)-SUM
C      PRINT*,I,J,E,E/FACT
  100 CONTINUE
      EE(I)=REAL(E/FACT)
   90 CONTINUE
C 200 FORMAT(1X,6F10.4)
C
C     Finally transform the abscissae to (a,b)
C
      DO 300 I=1,NOUT
      DO 310 J=1,I
       XX(I,J)=REAL(XXX(I,J)*S+LAM)
       WW(I,J)=REAL(WWW(I,J))
  310 CONTINUE
  300 CONTINUE
C      PRINT*,(XX(NOUT,J),J=1,NOUT)
C      PRINT*,(WW(NOUT,J),J=1,NOUT)
C      PRINT*,'EE='
C      PRINT*,(EE(J),J=1,NOUT)
      END
c
c**************************************************************************
c     This program is used to calulate the weights and absissae for the 
c     numerical integration FOR SETAR MODEL.
c***************************************************************************
      SUBROUTINE RABWG
      IMPLICIT LOGICAL(A-Z)
c     REAL LAM,S,DM,PTOUT
      INTEGER L,M,JJ,KK,TJ,TN
c
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000)
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,   
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V
c
      M=MFINAL
      IF(M.EQ.ID+1) THEN
      L=1
      TT=1
      UU=1
      VV=0
      TN=0
c
      CALL ABWG(L,2,1)
      AT(2)=TT
      AT(1)=AT(2)
      DO 50 KK=2,AT(1)
      ABSC(1,KK)=ABSC(2,KK)
      WGHT(1,KK)=WGHT(2,KK)
      LEVL1(KK)=LEVL(KK)
50    CONTINUE
      ELSE
      TT=1
      L=1
      UU=1
      VV=0
      TN=0
      DO 40 JJ=2,AT(1)
      IF(LEVL1(JJ).GE.LEVL1(JJ+1)) THEN
      X(K+L)=ABSC(1,JJ)
      TJ=LEVL1(JJ)
      write(*,*) ' voor stnod in rabwg'
c
      CALL STNOD1(WGHT(1,JJ),ABSC(1,JJ),2,JJ,TJ)
c
      CALL ABWG(L+1,2,JJ)
      L=LEVL1(JJ+1)-1
      ELSE
      TJ=LEVL1(JJ)
      L=TJ-1
      X(K+L)=ABSC(1,JJ)
      CALL STNOD1(WGHT(1,JJ),ABSC(1,JJ),2,JJ,TJ)
      L=LEVL1(JJ+1)-1
      GOTO 40
      END IF
40    CONTINUE
      AT(2)=TT
      AT(1)=AT(2)
      DO 70 KK=2,AT(1)
      ABSC(1,KK)=ABSC(2,KK)
      WGHT(1,KK)=WGHT(2,KK)
      LEVL1(KK)=LEVL(KK)
70    CONTINUE
      END IF
      PRINT*,'AT(1)=',AT(1)
      END
c
c
      SUBROUTINE ABWG(L,ML,JJ)
      IMPLICIT LOGICAL(A-Z)
      INTEGER I,J,NMPTS,NPTS,NOUT,KK,NDIM,IR,L,ML,JJ,TN,L1,NE,JJJ
c
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000)
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V
c
c
      DIMENSION MESH(100),WW(0:10,0:10),XX(0:10,0:10),EE(0:10)
      REAL A,LAM,S,DM,T1,MESH,WW,XX,EE,AA,T2,T3,T4
      REAL PTOUT,AF(4000),AE(4000),PTOUT1,PTOUT2,AA1,AA2,T5,T6
      REAL T7,T8,T9,T10
      REAL*8 PT,S15ABF
c     real*8 pt, erfc
c
      INTEGER*4 IFAIL
      EXTERNAL S15ABF
      LOGICAL STD
      NPTS=3
      NDIM=10
      CALL LAMDA1(L,LAM,IR)
      S=SLAM(IR)
      DO 40 I=1,N+1
      MESH(I)=T(I)
40    CONTINUE
      NMPTS=N+1
      DO 50 I=0,6
      MESH(I+N+2)=LAM+(I-3)*S
50    CONTINUE
      NMPTS=NMPTS+7
      DO 60 I=NMPTS,1,-1
      DO 70 J=1,I-1
      IF (MESH(J)  .GT. MESH(J+1)) THEN
      A=MESH(J)
      MESH(J)=MESH(J+1)
      MESH(J+1)=A
      END IF
70    CONTINUE
60    CONTINUE
      DO 30 J=1,NMPTS-1
      IF(ABS(MESH(J)-MESH(J+1)).LT.1E-4) GOTO 31
      STD=.TRUE.
      DO 300 I=2,N
      IF(ABS(MESH(J)-T(I)).LT.1E-6) STD=.FALSE.
      IF(ABS(MESH(J+1)-T(I)).LT.1E-6) STD=.FALSE.
300   CONTINUE
      CALL WWXX(MESH(J),MESH(J+1),LAM,S,NPTS,WW,XX,EE,NDIM,NOUT)
      T1=0
      T5=0
      T6=0
      T7=0
      T9=0
      DO 190 KK=1,NOUT
      X(K+L)=XX(NOUT,KK)
      CALL STNOD1(WW(NOUT,KK),XX(NOUT,KK),ML,JJ,0)
      L1=L+1
      CALL MANDV(ID,L1,1)
      PTOUT=X(L1+K+ID-1)
      DM=MSE(ID)
      PTOUT=(XXX-PTOUT)/SQRT(DM)
      PTOUT1=(XMI-PTOUT)/SQRT(DM)
      PTOUT2=(XMA-PTOUT)/SQRT(DM)
      AA=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
      AA1=EXP(-0.5*PTOUT1**2)/R2PI/SQRT(DM)
      AA2=EXP(-0.5*PTOUT2**2)/R2PI/SQRT(DM)
      T1=T1+AA*WW(NOUT,KK)                 
      T5=T5+AA1*WW(NOUT,KK)
      T6=T6+AA2*WW(NOUT,KK)
      T7=T7+PTOUT*WW(NOUT,KK)
C      T9=T9+(DM+PTOUT**2)*WW(NOUT,KK)
        PT=DBLE(PTOUT)
        IFAIL=0
        T9=T9+S15ABF(PT,IFAIL)
c       t9=t9+erfc(-pt/sqrt(2))/2   
190   CONTINUE
      AE(1)=MESH(J)
      AE(2)=(MESH(J+1)+MESH(J))*0.5
      AE(3)=MESH(J+1)
      NE=3 
370   T2=0     
      T3=0
      T4=0
      T8=0
      T10=0
      DO 10 JJJ=1,NE-1
      CALL WWXX(AE(JJJ),AE(JJJ+1),LAM,S,NPTS,WW,XX,EE,NDIM,NOUT)
      DO 220 KK=1,NOUT
      X(K+L)=XX(NOUT,KK)  
      CALL STNOD1(WW(NOUT,KK),XX(NOUT,KK),ML+1,JJ,0)
      L1=L+1
      CALL MANDV(ID,L1,1)
      PTOUT=X(L1+K+ID-1)
      DM=MSE(ID)
       PTOUT=(XXX-PTOUT)/SQRT(DM)
      PTOUT1=(XMI-PTOUT)/SQRT(DM)
      PTOUT2=(XMA-PTOUT)/SQRT(DM)
      AA=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
      AA1=EXP(-0.5*PTOUT1**2)/R2PI/SQRT(DM)
      AA2=EXP(-0.5*PTOUT2**2)/R2PI/SQRT(DM)
      T2=T2+AA*WW(NOUT,KK)
      T3=T3+AA1*WW(NOUT,KK)
      T4=T4+AA2*WW(NOUT,KK)
      T8=T8+PTOUT*WW(NOUT,KK)
C      T10=T10+(DM+PTOUT**2)*WW(NOUT,KK)
        PT=DBLE(PTOUT)
        IFAIL=0
         T10=T10+S15ABF(PT,IFAIL)
c        t10=t10+erfc(-pt/sqrt(2))/2   
220   CONTINUE
10    CONTINUE
C      IF(((ABS(T1-T2).LT.ABS(T2)*EPS).OR.(ABS(T2).LT.EPS)).AND.
C     *   ((ABS(T5-T3).LT.ABS(T3)*EPS).OR.(ABS(T3).LT.EPS)).AND.
C     *   ((ABS(T6-T4).LT.ABS(T4)*EPS).OR.(ABS(T4).LT.EPS)).AND.
C     *   ((ABS(T7-T8).LT.ABS(T8)*EPS).OR.(ABS(T8).LT.EPS)).AND.
C     *   ((ABS(T9-T10).LT.ABS(T10)*EPS).OR.(ABS(T10).LT.EPS))) THEN
       IF(((ABS(T1-T2).LT.ABS(T2)*EPS).OR.(ABS(T2).LT.EPS)).AND.
     *    ((ABS(T5-T3).LT.ABS(T3)*EPS).OR.(ABS(T3).LT.EPS)).AND.
     *    ((ABS(T6-T4).LT.ABS(T4)*EPS).OR.(ABS(T4).LT.EPS))) THEN
      UU=1
      TN=TT
      VV=0
      GOTO 30
      ELSE
      DO 20 JJJ=1,NE
      AF(2*JJJ-1)=AE(JJJ)
20    CONTINUE
      DO 12 JJJ=1,NE-1
      AE(2*JJJ)=(AF(2*JJJ-1)+AF(2*JJJ+1))/2
      AE(2*JJJ-1)=AF(2*JJJ-1)
12    CONTINUE
      AE(2*NE-1)=AF(2*NE-1)
      NE=NE*2-1
      DO 330 KK=2,UU
      ABSC(2,KK+TN+VV)=CABSC(KK)
      WGHT(2,KK+TN+VV)=CWGHT(KK)
      LEVL(KK+TN+VV)=MFINAL-ID+1
330   CONTINUE
      TT=UU+TN+VV
      UU=1
      T1=T2
      T5=T3
      T6=T4
      GOTO 370
      END IF
C      END IF
C      END IF
c     GOTO 30
31    PRINT*,'INTERVAL IS TOO SMALL'
30    CONTINUE
      END
c
      SUBROUTINE COEFFS
C***********************************************************************
C     Sets up the coefficients ALAM(I,J),I=1,NS,J=1,K, and BLAM(I),I=1,NSS
C     for the function LAMBDA and also the points of discontinuity
C     The point of discontinuity is T(2)=3.05. The discontinuity is
C     in the variable X(5) in lambda and K=6.Hence DSCNT=5.
C     Also sets up the array SLAM(I),I=1,2 for the variance in the
C     two different subsets.
C************************************************************************     
      IMPLICIT LOGICAL (A-Z)
C
C     Global variables
C
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V

C
C     Set order of model,K, and number of regions, N.
C
      K=10
      N=2
C
C     Set threshold values
C
      T(1)=-1.E7
      T(2)=11.9284
      T(3)=1.E7
C
C     Now the coefficient parameters, coeff of X(t-K) FIRST, X(t-1) LAST.
C
      ALAM(1,1)= 0.10
      ALAM(1,2)= 0.20
      ALAM(1,3)=-0.28
      ALAM(1,4)= 0.19
      ALAM(1,5)= 0.00
      ALAM(1,6)=-0.21
      ALAM(1,7)= 0.16
      ALAM(1,8)=-0.32
      ALAM(1,9)= 0.08
      ALAM(1,10)= 0.86

      ALAM(2,1)= 0.0
      ALAM(2,2)= 0.0
      ALAM(2,3)= 0.0
      ALAM(2,4)= 0.0
      ALAM(2,5)= 0.0
      ALAM(2,6)= 0.0
      ALAM(2,7)= 0.0
      ALAM(2,8)= 0.0
      ALAM(2,9)=-0.78
      ALAM(2,10)=1.41
C
C     Next the constant terms for each submodel
C
      BLAM(1)  = 1.89
      BLAM(2)  = 4.53
C
C     Standard deviations for the submodels
C
      SLAM(1)  = SQRT(1.946)
      SLAM(2)  = SQRT(6.302)
C
C     Set up the forecast origin, with X(t-i) in X(K-i), i=0,...,K-1
C
      X(1)=2*(SQRT(104.5+1)-1)
      X(2)=2*(SQRT(66.6 +1)-1)
      X(3)=2*(SQRT(68.9 +1)-1)
      X(4)=2*(SQRT(38.0 +1)-1)
      X(5)=2*(SQRT(34.5 +1)-1)
      X(6)=2*(SQRT(15.5 +1)-1)
      X(7)=2*(SQRT(12.6 +1)-1)
      X(8)=2*(SQRT(27.5 +1)-1)
      X(9)=2*(SQRT(92.5 +1)-1)
      X(10)=2*(SQRT(155.4+1)-1)
C
C     Set the parameter ID. IF(M.LE.ID) THEN integration without checks
C
      ID=2
      END
C
C     End of SUBROUTINE COEFFS
C
      SUBROUTINE VAR(M,L,POUT)
C****************************************************************************
C     Calculates the variance of the conditional pdf as far as ID steps ahead,
C     using a known two point rule.
C****************************************************************************
      IMPLICIT LOGICAL(A-Z)
C
C     Arguments
C
      INTEGER M,L
      REAL POUT
C
C     Global variables
C
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V
C
C     Local variables
C
      REAL S,SUM,PTOUT,LAM
C
C     First calculate lambda
C
      CALL LAMBDA(L,LAM,S)
C
C     Degenerate case for the recursion
C
      IF(M.EQ.1) THEN
       POUT=LAM**2+S**2

       ELSE
C
C     Calculate variance by known 2 point quadrature rule
C
       X(L+K)=LAM+S
       CALL VAR(M-1,L+1,SUM)
       X(L+K)=LAM-S
       CALL VAR(M-1,L+1,PTOUT)
       POUT=(SUM+PTOUT)/2.0
      ENDIF
      END


cc     nag pc graphics library, release 1. nag copyright 1988
c
c	subroutine ptplot(x,y,umi,uma,vmi,vma,xmi,xma,ymi,yma,
c    1itype,ksym,np,tx,ty,tg,isup)
c     .. parameters ..
c     integer         nin, nout
c     parameter       (nin=4,nout=8)
c     integer         margin, idim
c     parameter       (margin=1,idim=1000)
c     .. local scalars ..
c     double precision uma, umi, vma, vmi, xma, xmi, yma, ymi
c     integer         i, ifail, itype, ksym, np
c     .. local arrays ..
c     double precision x(idim), y(idim)
c	character*80 tx,ty,tg
c     .. external subroutines ..
c     external        j06aaf, j06ahf, j06baf, j06vaf, j06wbf,
c    *                j06wcf, j06xff
c     .. intrinsic functions ..
c     intrinsic       dble, sin
c     .. executable statements ..
c	if(isup.eq.0)then
c
c     call nag graphical interface to initialise
c     the nag graphics and indicate the data region.
c
c     call j06wbf(xmi,xma,ymi,yma,margin)
c     call j06wcf(umi,uma,vmi,vma)
c
c     plot title and axis
c
c     call j06ahf(tg)
c     call j06aaf
c	endif
c
c     set high quality characters and markers
c
c     call j06xff(2)
c     if (np.le.0 .or. np.gt.idim) then
c	 write (nout,fmt=99999)
c     else
c
c        plot the data
c
c	ifail=0
c	 call j06baf(x,y,np,itype,ksym,ifail)
c     end if
c
c99999 format (' np is out of range')
c      end
c
c
c
c
c     start of subroutine root
c
      subroutine root(c,ans)
c
c     finds the point ans where the f(m,x/xt) takes the value c. uses
c     newtons' method.
c
      implicit logical(a-z)
c
c     arguments
c
      real c,ans
c
c     global variables
c

      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V
c
c     local variables
c
      real y,fx,fdx,ans1,ans2
c
c     newton's method
c
      write(*,*) ' in root voor eval1 '
      call eval1(1,fdx,fx)
      last=1
99    y=fx
      ans1=xxx
      xxx=xxx+sign(1e20*xinc,c-fx)
      ans2=max(ans1,xxx)
      ans1=min(ans1,xxx)
      call eval1(1,fdx,fx)
      if((fx-c)*(y-c).lt.0.0)then
      y=0.5*(ans1+ans2)
	ans=ans1
      else
      goto 99
      endif
c      while(abs(ans-y).gt.1e-4) do
202     continue
	if(abs(ans-y).gt.1e-4)then
	ans=y
	xxx=ans
	call eval1(1,fdx,fx)

	if(fdx.gt.1e-10) then
	y=ans-(fx-c)/fdx
	else
c        while (abs(ans1-ans2).gt.1e-4) do
201     continue
	if(abs(ans1-ans2).gt.1e-4) then
	y=0.5*(ans1+ans2)
	xxx=y
	call eval1(1,fdx,fx)
	if(fx.lt.c) then
	ans1=y
	else
	ans2=y
	end if
	goto 201
	else
c        endwhile
	y=0.5*(ans1+ans2)
	goto 19
	end if
	end if
c        y=ans-(fx-c)/fdx
      if(y.lt.ans1.or.y.gt.ans2)then
203     continue
	if(abs(ans1-ans2).gt.1e-4) then
c      while(abs(ans1-ans2).gt.1e-4)do
      y=0.5*(ans1+ans2)
      xxx=y
      call eval1(1,fdx,fx)
      if(fx.lt.c)then
      ans1=y
      else
      ans2=y
      endif
c      endwhile
	goto 203
	else
	goto 19
	end if
      endif
      if(fx.lt.c)then
      ans1=y
      else
      ans2=y
      endif
c      endwhile
	goto 202
	end if
c        else
19    ans=y
c        end if
      end
c
c      end of subroutine root
c
c
c     start of subroutine lambda
c

      subroutine lambda(l,sum,s)
      implicit logical(a-z)
c
c     arguments
c
      integer l
c
c     global variables
c
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V

c
c     local variables
c
      real sum,s
      integer i,j
      i=1
      do 10 j=2,n
      if(x(l-id+k).lt.t(j)) goto 9
      i=j
10    continue
9     continue
c
c     i is the subspace number
c
      sum=blam(i)
      do 20 j=1,k
       sum=sum+alam(i,j)*x(l+j-1)
   20 continue
      s=slam(i)
      end
c
c     end of subroutine lambda
c
c     start of subroutine lamda1
c
      subroutine lamda1(l,sum,i)
      implicit logical(a-z)
c
c     arguments
c
      integer l,i
c
c     global variables
c

      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V
c
c     local variables
c
      real sum
      integer j
      i=1
      do 10 j=2,n
      if(x(l-id+k).lt.t(j)) goto 9
      i=j
10    continue
9     continue
c
c     i is the subspace number
c
      sum=blam(i)
      do 20 j=1,k
       sum=sum+alam(i,j)*x(l+j-1)
   20 continue
      end
c
      SUBROUTINE MOMENT(C,D,II,V,MDIM,NMTS)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     Program to calculate the moments II(i)=u**iexp(-u*u/2)/r2pi
C     between a and b for i=0,...,nmts and the generalised moments
C     V(i)=P(i)*exp(-u*u/2)/rtpi
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER mdim,NMTS
      DIMENSION II(0:MDIM),V(0:MDIM)
      DOUBLE PRECISION C,D,II,V
C
C     Local variables
C
      DIMENSION ZZ(0:20),COEF(0:20,0:20),III(0:20)
      DOUBLE PRECISION ZZ,COEF,E,F,SUM,R2PI,III
      REAL*8 W
      DOUBLE PRECISION CC,DD,WW
      INTEGER I,J,ifaiL
C     Function references
C
      REAL*8 S15ABF
c     real*8 erfc
c
      DD=D
      WW=S15ABF(DD,IFAIL)
c     ww=erfc(-dd/sqrt(2))/2   
      CC=C
      WW=WW-S15ABF(CC,IFAIL)
c     ww=erfc(-cc/sqrt(2))/2   
c
c     W=WW
      R2PI=SQRT(8.0*ATAN(1.0))
      ZZ(0)=WW
      F=EXP(-DD*DD/2.0)
      E=EXP(-CC*CC/2.0)
      DO 20 I=1,NMTS
        ZZ(I)=(F-E)/R2PI
        E=CC*E
        F=DD*F
   20 CONTINUE
C
C     We have now calculated the integrated terms in the definition
C     of the II(N).Now calculate the II(N) from the recurrence
C     relation II(N)=(N-1)*II(N-2)-U**(N-1)EXP(-U*U/2)/R2PI where
C     the last term is evaluated at c,d
C
      III(0)=ZZ(0)
      III(1)=-ZZ(1)
      DO 50 J=2,NMTS
        III(J)=(J-1)*III(J-2)-ZZ(J)
   50 CONTINUE
C
C     The moments II(N) have been calculated,now find the generalised
C     moments.First calculate the coefficients of the shifted Legendre
C     polynomials.If c and/or d is very large replace them by CBAR,DBAR
C     i.e work with the moments based on a finite interval.
C
      
CV      CONST=9.0
CV      IF(CC.GT.0.0) THEN
CV       CBAR=CC
CV       E=SQRT(CC*CC+CONST)
CV       DBAR=DD
CV       IF(E.LT.DBAR) DBAR=E
CV      ELSEIF(DD.LT.0.0) THEN
CV       DBAR=DD
CV       E=-SQRT(DD*DD+CONST)
CV       CBAR=CC
CV       IF(E.GT.CBAR) CBAR=E
CV      ELSE
CV       E=SQRT(CONST)
CV       CBAR=CC
CV       IF(-E.GT.CBAR) CBAR=-E
CV       DBAR=DD
CV       IF(E.LT.DBAR) DBAR=E
CV      ENDIF
CV      E=2.0/(DBAR-CBAR)
CV       F=-(CBAR+DBAR)/(DBAR-CBAR)
       E=2.0/(DD-CC)
       F=-(CC+DD)/(DD-CC)
C      PRINT*,'E,F'
C      PRINT*,E,F
C
C     Calculate the coeffs for shifted Legendre
C
      COEF(0,0)=1.0
      COEF(0,1)=0.0
      COEF(0,2)=0.0
      COEF(1,0)=F
      COEF(1,1)=E
      COEF(1,2)=0.0
      COEF(1,3)=0.0
      DO 60 I=2,NMTS
      DO 70 J=1,I
        COEF(I,J)=COEF(I-1,J)*F*(2.0*I-1.0)/I-(I-1)*COEF(I-2,J)/I
        COEF(I,J)=COEF(I,J)+E*(2.0*I-1.0)/I*COEF(I-1,J-1)
   70 CONTINUE
      COEF(I,0)=COEF(I-1,0)*F*(2.0*I-1.0)/I-(I-1)*COEF(I-2,0)/I
      COEF(I,I+1)=0.0
      COEF(I,I+2)=0.0
   60 CONTINUE
C
C     Calculate coeffs of Hermite
C
C     E=SQRT(2.0)
C     COEF(0,0)=1.0
C     COEF(0,1)=0.0
C     COEF(0,2)=0.0
C     COEF(1,0)=0.0
C     COEF(1,1)=E
C     COEF(1,2)=0.0
C     COEF(1,3)=0.0
C     DO 61 I=2,NMTS
C     DO 71 J=1,I
C       COEF(I,J)=E*COEF(I-1,J-1)-2.0*(I-1)*COEF(I-2,J)
C  71 CONTINUE
C     COEF(I,0)=-2.0*(I-1)*COEF(I-2,0)
C     COEF(I,I+1)=0.0
C     COEF(I,I+2)=0.0
C  61 CONTINUE
C
C     Calculate the coeffs for the scaled Laguerre
C
C     E=CC
C     COEF(0,0)=1.0
C     COEF(0,1)=0.0
C     COEF(0,2)=0.0
C     COEF(1,0)=1.0+E*E
C     COEF(1,1)=-E
C     COEF(1,2)=0.0
C     COEF(1,3)=0.0
C     DO 61 I=2,NMTS
C     DO 71 J=1,I
C       COEF(I,J)=-E*COEF(I-1,J-1)+(2*I-1+E*E)*COEF(I-1,J)
C    *              -(I-1)**2*COEF(I-2,J)
C  71 CONTINUE
C     COEF(I,0)=(2.0*I-1.0+E*E)*COEF(I-1,0)-(I-1)**2*COEF(I-2,0)
C     COEF(I,I+1)=0.0
C     COEF(I,I+2)=0.0
C  61 CONTINUE
C
C     Calculate binomial coeffs
C
C     COEF(0,0)=1.0
C     COEF(0,1)=0.0
C     COEF(1,0)=-CC
C     COEF(1,1)=1.0
C     COEF(1,2)=0.0
C     DO 65 I=2,NMTS
C     DO 66 J=1,I
C      COEF(I,J)=COEF(I-1,J-1)-CC*COEF(I-1,J)
C  66 CONTINUE
C     COEF(I,0)=-CC*COEF(I-1,0)
C     COEF(I,I+1)=0.0
C  65 CONTINUE
C     DO 62 I=0,NMTS
C      PRINT 63,(COEF(I,J),J=0,I)
C  62 CONTINUE
C  63  FORMAT(1X,10F6.2)
C
C     ...and finally the generalised moments
C
      DO 80 I=0,NMTS
        SUM=0.0
        DO 90 J=0,I
          SUM=SUM+COEF(I,J)*III(J)
   90   CONTINUE
        V(I)=SUM
        II(I)=III(I)
   80 CONTINUE
      END
C
C     End of MOMENT
C
C
C     Start of FUNMAT
C
      SUBROUTINE FUNMAT(C,D,NPTS,AA,BB,CC,NDIM)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C
C     Calculates the coefficients in the fundamental matrix
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM
      DIMENSION AA(-1:NDIM),BB(0:NDIM),CC(0:NDIM)
      DOUBLE PRECISION AA,BB,CC,C,D
C
C     Local variables
C
      DOUBLE PRECISION E,F,CBAR,DBAR,CONST
      INTEGER I
C
C     Shifted Legendre
C
      CONST=9.0
      IF(C.GT.0.0) THEN
       CBAR=C
       E=SQRT(C*C+CONST)
       DBAR=D
       IF(E.LT.DBAR) DBAR=E
      ELSEIF(D.LT.0.0) THEN
       DBAR=D
       E=-SQRT(D*D+CONST)
       CBAR=C
       IF(E.GT.CBAR) CBAR=E
      ELSE
       E=SQRT(CONST)
       CBAR=C
       IF(-E.GT.CBAR) CBAR=-E
       DBAR=D
       IF(E.LT.DBAR) DBAR=E
      ENDIF
      E=(DBAR-CBAR)/2.0
      F=(CBAR+DBAR)/2.0
      AA(-1)=0.0
      DO 20 I=0,NPTS
       AA(I)=(I+1.0)*E/(2.0*I+1.0)
       BB(I)=F
       CC(I)=I*E/(2.0*I+1.0)
   20 CONTINUE
C
C     Hermite fundamental matrix
C
C     E=SQRT(2.0)
C     AA(-1)=E/2.0
C     DO 30 I=0,NPTS
C       AA(I)=E/2.0
C       BB(I)=0.0
C       CC(I)=E*I
C  30 CONTINUE
C
C     Laguerre
C
C     AA(-1)=0.0
C     DO 50 I=0,NPTS
C      AA(I)=-1.0/C
C      BB(I)=(1.0+2.0*I+C*C)/C
C      CC(I)=-I*I/C
C  50 CONTINUE
C
C     Binomial
C
C     DO 40 I=0,NPTS
C      AA(I)=1.0
C      BB(I)=C
C      CC(I)=0.0
C  40 CONTINUE
      END
C
C     End of FUNMAT
C
C
C     Start of TERMAT
C
      SUBROUTINE TERMAT(AA,BB,CC,II,V,NPTS,ALPHA,BETA,GAMMA,NDIM,MDIM,
     *                   NOUT)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C
C     Sets up the terminal matrix
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM,MDIM,NOUT
      DIMENSION AA(-1:NDIM),BB(0:NDIM),CC(0:NDIM),II(0:MDIM),
     * V(0:MDIM),ALPHA(0:NDIM),BETA(0:NDIM),GAMMA(0:NDIM)
      DOUBLE PRECISION AA,BB,CC,II,V,ALPHA,BETA,GAMMA
c
C
C     Local variables
C
      DIMENSION SS(-1:20,0:20)
      DOUBLE PRECISION SS,R,S,T
      INTEGER I,J,NMTS
      NMTS=2*NPTS
C
C     Initialize the first 2 rows of SS
C
      GAMMA(0)=0.0
      DO 20 J=0,NMTS
       SS(-1,J)=0.0
   20 CONTINUE
      DO 30 J=0,NMTS
        SS(0,J)=V(J)/V(0)
   30 CONTINUE

C
C     Now use the recurrence relation for the other rows
C
      DO 40 I=0,NPTS-1
       T=AA(I-1)
       S=AA(I)*SS(I,I+1)+BB(I)-AA(I-1)*SS(I-1,I)
       R=(BB(I+1)-S)*SS(I,I+1)+AA(I+1)*SS(I,I+2)-AA(I-1)*SS(I-1,I+1)
     *       +CC(I+1)
       BETA(I)=S
       IF(I.EQ.NPTS-1) GOTO 40
       DO 50 J=0,I
        SS(I+1,J)=0.0
   50  CONTINUE
        SS(I+1,I+1)=1.0
       DO 70 J=I+2,2*NPTS-1-I
        SS(I+1,J)=1.0/R*((BB(J)-S)*SS(I,J)+AA(J)*SS(I,J+1)+
     *                CC(J)*SS(I,J-1)-T*SS(I-1,J))
   70  CONTINUE
       IF(AA(I)*R.LT.0.0) THEN
C       PRINT*,'  ERROR IN TERMINAL MATRIX '
C       PRINT*,'  VALUE OF I IS',I,'CAN ONLY COMPUTE RULES UP TO'
C       PRINT*,'     LEVEL ',I+1
        NOUT=I+1
        RETURN
       ENDIF
       ALPHA(I)=SQRT(AA(I)*R)
       GAMMA(I+1)=ALPHA(I)
   40 CONTINUE
      END
C
C     End of TERMAT
C
C
C     Start of NEWTON
C
      SUBROUTINE NEWTON(AA,BB,ALPHA,BETA,GAMMA,NPTS,NDIM,W,X,BOOL)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        LOGICAL BOOL

C
C     Calculates the root(X) of the orthogonal polynomial which lies
C     in (a,b) and the associated weight(W)
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM
      DIMENSION ALPHA(0:NDIM),BETA(0:NDIM),GAMMA(0:NDIM)
      DOUBLE PRECISION AA,BB,ALPHA,BETA,GAMMA,W,X
C
C     Local variables
C
      DOUBLE PRECISION A,B,FA,FB,FX,FDX,R,EPS,Y,SIGN
      INTEGER J
      EPS=1D-12
      BOOL=.TRUE.
C
C     First test if the interval is semi-infinite.If it is try to
C     find a finite interval (a,b) which contains a root.
C
      A=AA
      B=BB
      IF((A.LT.-1E3).OR.(B.GT.1E3)) THEN
        IF(A.LT.-1E3) THEN
         X=B
         SIGN=-1.1
        ELSE
         X=A
         SIGN=1.1
        ENDIF
        CALL FANDD(X,FA,FDX,R,NPTS,ALPHA,BETA,NDIM)
        DO 20 J=1,5
         X=X+SIGN
         CALL FANDD(X,FB,FDX,R,NPTS,ALPHA,BETA,NDIM)
         IF(FA*FB.LT.0.0) GOTO 300
   20   CONTINUE
C        PRINT*,'NO ROOT IN INTERVAL '
        BOOL=.FALSE.
        RETURN
  300   IF(SIGN.GT.0.0) THEN
         A=X-SIGN
         B=X
        ELSE
         A=X
         B=X-SIGN
        ENDIF
C       PRINT*,'SEMI INF REDUCED TO ',A,B
      ENDIF
C
C     Test for sign change in (a,b)
C
      CALL FANDD(A,FA,FDX,R,NPTS,ALPHA,BETA,NDIM)
      CALL FANDD(B,FB,FDX,R,NPTS,ALPHA,BETA,NDIM)
      IF(FA*FB.GT.0.0) THEN
C        PRINT*,'   NO ROOT IN ',A,B
C        PRINT*,' CANNOT COMPUTE',NPTS,' RULE '
        BOOL=.FALSE.
        RETURN
      ELSE
C
C     Compute new iterate
C
  200   X=(A+B)/2.0
  100   CALL FANDD(X,FX,FDX,R,NPTS,ALPHA,BETA,NDIM)
        Y=X-FX/FDX
C       PRINT*,X,Y
        IF(ABS(X-Y).LT.EPS) THEN
         W=R/FDX
         X=Y
        ELSEIF(A.LT.Y.AND.Y.LT.B) THEN
           X=Y
           GOTO 100
        ELSE
C
C     Bisection
C
          IF(FA*FX.LT.0.0) THEN
            B=X
          ELSE
            A=X
          ENDIF
          GOTO 200
        ENDIF
      ENDIF
      END
C
C     End of NEWTON
C
C
C     Start of subroutine FANDD
C
      SUBROUTINE FANDD(X,FX,FDX,R,NPTS,ALPHA,BETA,NDIM)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C
C     Subroutine to calculate the orthogonal function,its derivative
C     and the value c(1)
C
C      IMPLICIT LOGICAL(A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM
      DIMENSION ALPHA(0:NDIM),BETA(0:NDIM)
      DOUBLE PRECISION ALPHA,BETA,X,FX,FDX,R
C
C     Local variables
C
      DIMENSION C(0:100),D(0:100)
      DOUBLE PRECISION C,D
      INTEGER J
      C(NPTS+1)=0.0
      D(NPTS+1)=0.0
      C(NPTS)=1.0
      D(NPTS)=0.0
C      PRINT*,(ALPHA(J),BETA(J),J=NPTS-1,0,-1)
      J=NPTS-1
      C(J)=BETA(J)-X
      D(J)=-1.0
      DO 20 J=NPTS-2,0,-1
       C(J)=(BETA(J)-X)*C(J+1)-ALPHA(J)**2*C(J+2)
       D(J)=(BETA(J)-X)*D(J+1)-ALPHA(J)**2*D(J+2)-C(J+1)
   20 CONTINUE
      FX=C(0)
      FDX=D(0)
      R=C(1)
      END
C
C     End of FANDD
C
c
      SUBROUTINE STNOD1(W,A,ML,JJ,TJ)
      IMPLICIT LOGICAL(A-Z)
      REAL W,A
      INTEGER ML,JJ,TJ
c
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
      
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V

      IF(TJ.NE.0) THEN
      VV=VV+1
      TT=TT+1
      IF(TT.GT.50000) THEN
      PRINT*,'STACK HAS OVERFLOWED'
      STOP
      END IF
      WGHT(ML,TT)=W
      ABSC(ML,TT)=A
      LEVL(TT)=TJ
      GOTO 100
      END IF
      IF(ML.EQ.2) THEN
      TT=TT+1
      IF(TT.GT.50000) THEN
      PRINT*,'STACK HAS OVERFLOWED'
      STOP
      END IF
      LEVL(TT)=MFINAL-ID+1
      WGHT(ML,TT)=W
      ABSC(ML,TT)=A
      ELSE
      UU=UU+1
      CWGHT(UU)=W
      CABSC(UU)=A
      END IF
100   RETURN
      END
c
c      
      SUBROUTINE EVAL1(ICUM,A,B)
      IMPLICIT LOGICAL(A-Z)
      REAL A,SUM1,SUM2,DM,PTOUT,B,W(20)
      INTEGER ICUM,I,L,IK,ifail
c
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
      
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V

      DOUBLE PRECISION DDXX
      REAL S15ABF
c     real erfc
c
      EXTERNAL S15ABF
      write(*,*) 'mfinal and id: ',mfinal,id
      IF (MFINAL.LE.ID) THEN
          PTOUT=LASTL
          DM=LASTV
          MEANN(MFINAL)=PTOUT
          VARR(MFINAL)=DM
          PTOUT=(XXX-PTOUT)/SQRT(DM)
          IF(ICUM.GT.0) THEN
            DDXX=DBLE(PTOUT)
            IFAIL=0
            B=S15ABF(DDXX,IFAIL)
            write(*,*) 'ddxx voor erfc = ',ddxx
            write(*,*) ' icum = ',icum
c           b=erfc(-ddxx/sqrt(2))/2   
            write(*,*) ' b na erfc  = ',b
          ENDIF
          A=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
          write(*,*) ' getal a=', a
      ELSE
          DO 20 I=1,K
             W(I)=1.0
20        CONTINUE
          L=1
          LEVL1(AT(1)+1)=2
          SUM1=0
          SUM2=0
          IF(LAST.EQ.0) THEN
             MEANN(MFINAL)=0
             VARR(MFINAL)=0
          ENDIF
          DO 30 I=2,AT(1)
             IK=I-1
             L=1+L
             X(L+K-1)=ABSC(1,I)
             W(L+K-1)=WGHT(1,I)*W(L+K-2)
          IF(LEVL1(I).GE.LEVL1(I+1)) THEN
             IF(LAST.EQ.0) THEN
                V=V+W(L+K-1)
                write(*,*) ' voor mandv in procedure eval1'
                CALL MANDV(ID,L,1)
                PTOUT=X(L+K+ID-1)
                DM=MSE(ID)
                FABS(1,IK)=PTOUT
                FABS(2,IK)=DM
                MEANN(MFINAL)=MEANN(MFINAL)+PTOUT*W(L+K-1)
                VARR(MFINAL)=VARR(MFINAL)+(DM+PTOUT**2)*W(L+K-1)
             ELSE
                PTOUT=FABS(1,IK)
                DM=FABS(2,IK)
             ENDIF
             PTOUT=(XXX-PTOUT)/SQRT(DM)
             A=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
             write(*,*) 'ptout en a :', ptout,a
             SUM1=SUM1+W(L+K-1)*A
             IF(ICUM.GT.0) THEN
                DDXX=DBLE(PTOUT)
                IFAIL=0
                PTOUT=S15ABF(DDXX,IFAIL)
c               ptout=erfc(-ddxx/sqrt(2))/2   
                write(*,*) 'ptout in eval1 = ', ptout
c
                SUM2=SUM2+W(L+K-1)*PTOUT
             ENDIF
             L=LEVL1(I+1)-1
         ENDIF
30       CONTINUE
c
         A=SUM1/V
         B=SUM2/V
         write(*,*) ' waarden van a en b: ',a,b
c
         IF (LAST.EQ.0)THEN
            MEANN(MFINAL)=MEANN(MFINAL)/V
            VARR(MFINAL)=VARR(MFINAL)/V
            VARR(MFINAL)=VARR(MFINAL)-MEANN(MFINAL)**2
         ENDIF
      ENDIF
      END
c
c
      SUBROUTINE MEAN(M,L,POUT)
C
C     Calculates the mean of the conditional pdf as far as M<ID+1 steps ahead,
C     by iterating lambda.
C
      IMPLICIT LOGICAL(A-Z)
C
C     Arguments
C
      INTEGER M,L
      REAL POUT
C
C     Global variables
C
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
      
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V

C
C     Local variables
C
      INTEGER L1
      REAL S,LAM
C
C     First calculate lambda
C
      CALL LAMBDA(L,LAM,S)

      IF(M.EQ.1) THEN
       POUT=LAM

       ELSE

       X(L+K)=LAM
       DO 999 L1=1,M-2
       CALL LAMBDA(L+L1,LAM,S)
       X(L+L1+K)=LAM
999    CONTINUE
       CALL LAMBDA(M+L-1,POUT,S)
      ENDIF
      END
c
      SUBROUTINE MANDV(M,L,FINAL)
C
C     Calculates the mean of the conditional pdf as far as M<ID+1 steps ahead,
C     by iterating lambda.
C
      IMPLICIT LOGICAL(A-Z)
C
C     Arguments
C
      INTEGER M,L,FINAL
C
C     Global variables
C
      DIMENSION X(45),T(15),ABSC(2,50000),WGHT(2,50000),MSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2)
      REAL EPS,X,T,R2PI,ALAM,BLAM,SLAM,WGHT,XXX,XINC,LASTL,ABSC
     *  ,MSE,LASTV,FF(8,10),CABSC(1000),CWGHT(1000),XMI,XMA,V
      REAL FABS(2,50000),MEANN(12),VARR(12)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,UU,VV,LEVL1(50000)
      INTEGER LEVL(50000),TN
       COMMON K,N,R2PI,X,T,ALAM,BLAM,SLAM,EPS,MFINAL,ID,ABSC,WGHT,MSE,
      
     *   LEVL,TT,XXX,XINC,LAST,LASTL,LASTV,AT,FF,CABSC,CWGHT,UU,XMI,XMA
     *   ,LEVL1,VV,FABS,TN,VARR,MEANN,V

C
C     Local variables
C
      DIMENSION SM2(25),COFER(25,25)
      INTEGER L1,IR,IL1,IL2
      REAL S,LAM,C0,SM2,COFER
C
C     First calculate lambda
C
      write(*,*) 'first lambda'
c
      CALL LAMDA1(L,LAM,IR)
      COFER(1,1)=1.0
      SM2(1)=SLAM(IR)**2
      MSE(1)=SM2(1)
      X(L+K)=LAM
      DO 999 L1=1,M-1
      CALL LAMDA1(L+L1,LAM,IR)
      write(*,*) 'second lambda'
c
      X(L+L1+K)=LAM
      COFER(L1+1,L1+1)=1.0
      DO 10 IL1=1,L1
      C0=0.0
      DO 20 IL2=IL1,L1
      C0=C0+COFER(L1-IL2+IL1,IL1)*ALAM(IR,K-IL2+IL1)
20    CONTINUE
      COFER(L1+1,IL1)=C0
10    CONTINUE
      SM2(L1+1)=SLAM(IR)**2
      S=0.0
      IF(FINAL.EQ.1.AND.L1.NE.M-1)GOTO 999
      DO 30 IL1=1,L1+1
30    S=S+SM2(IL1)*COFER(L1+1,IL1)**2
      MSE(L1+1)=S
999   CONTINUE
      write(*,*) 'end mandv proced '
      END
c
C
      FUNCTION erfc(x)
      REAL erfc,x
CU    USES gammp,gammq
      REAL gammp,gammq
      if(x.lt.0.)then
        erfc=1.+gammp(.5,x**2)
      else
        erfc=gammq(.5,x**2)
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
c
      FUNCTION gammp(a,x)
      REAL a,gammp,x
CU    USES gcf,gser
      REAL gammcf,gamser,gln
      if(x.lt.0..or.a.le.0.)pause 'bad arguments in gammp'
      if(x.lt.a+1.)then
        call gser(gamser,a,x,gln)
        gammp=gamser
      else
        call gcf(gammcf,a,x,gln)
        gammp=1.-gammcf
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      SUBROUTINE gser(gamser,a,x,gln)
      INTEGER ITMAX
      REAL a,gamser,gln,x,EPS
      PARAMETER (ITMAX=100,EPS=3.e-7)
CU    USES gammln
      INTEGER n
      REAL ap,del,sum,gammln
      gln=gammln(a)
      if(x.le.0.)then
        if(x.lt.0.)pause 'x < 0 in gser'
        gamser=0.
        return
      endif
      ap=a
      sum=1./a
      del=sum
      do 11 n=1,ITMAX
        ap=ap+1.
        del=del*x/ap
        sum=sum+del
        if(abs(del).lt.abs(sum)*EPS)goto 1
11    continue
      pause 'a too large, ITMAX too small in gser'
1     gamser=sum*exp(-x+a*log(x)-gln)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION gammq(a,x)
      REAL a,gammq,x
CU    USES gcf,gser
      REAL gammcf,gamser,gln
      if(x.lt.0..or.a.le.0.)pause 'bad arguments in gammq'
      if(x.lt.a+1.)then
        call gser(gamser,a,x,gln)
        gammq=1.-gamser
      else
        call gcf(gammcf,a,x,gln)
        gammq=gammcf
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      SUBROUTINE gcf(gammcf,a,x,gln)
      INTEGER ITMAX
      REAL a,gammcf,gln,x,EPS,FPMIN
      PARAMETER (ITMAX=100,EPS=3.e-7,FPMIN=1.e-30)
CU    USES gammln
      INTEGER i
      REAL an,b,c,d,del,h,gammln
      gln=gammln(a)
      b=x+1.-a
      c=1./FPMIN
      d=1./b
      h=d
      do 11 i=1,ITMAX
        an=-i*(i-a)
        b=b+2.
        d=an*d+b
        if(abs(d).lt.FPMIN)d=FPMIN
        c=b+an/c
        if(abs(c).lt.FPMIN)c=FPMIN
        d=1./d
        del=d*c
        h=h*del
        if(abs(del-1.).lt.EPS)goto 1
11    continue
      pause 'a too large, ITMAX too small in gcf'
1     gammcf=exp(-x+a*log(x)-gln)*h
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION gammln(xx)
      REAL gammln,xx
      INTEGER j
      DOUBLE PRECISION ser,stp,tmp,x,y,cof(6)
      SAVE cof,stp
      DATA cof,stp/76.18009172947146d0,-86.50532032941677d0,
     *24.01409824083091d0,-1.231739572450155d0,.1208650973866179d-2,
     *-.5395239384953d-5,2.5066282746310005d0/
      x=xx
      y=x
      tmp=x+5.5d0
      tmp=(x+0.5d0)*log(tmp)-tmp
      ser=1.000000000190015d0
      do 11 j=1,6
        y=y+1.d0
        ser=ser+cof(j)/y
11    continue
      gammln=tmp+log(stp*ser/x)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
